/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.asm;

import org.blockartistry.DynSurround.asm.TransformLoader;
import org.blockartistry.DynSurround.asm.Transformer;
import org.blockartistry.DynSurround.asm.Transmorgrifier;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class PatchEntityArrow
extends Transmorgrifier {
    public PatchEntityArrow() {
        super("net.minecraft.entity.projectile.EntityArrow");
    }

    @Override
    public String name() {
        return "No Particles on Arrows";
    }

    @Override
    public boolean isEnabled() {
        return TransformLoader.config.getBoolean("Disable Arrow Critical Particle Trail", "asm", true, "");
    }

    @Override
    public boolean transmorgrify(ClassNode cn) {
        String[] names = new String[]{"onUpdate", "func_70071_h_"};
        String sig = "()V";
        MethodNode m = this.findMethod(cn, "()V", names);
        if (m != null) {
            this.logMethod(Transformer.log(), m, "Found!");
            for (int i = 0; i < m.instructions.size(); ++i) {
                AbstractInsnNode node = m.instructions.get(i);
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode mn = (MethodInsnNode)node;
                if (!"getIsCritical".equals(mn.name) && !"func_70241_g".equals(mn.name)) continue;
                m.instructions.set(mn.getPrevious(), (AbstractInsnNode)new InsnNode(0));
                m.instructions.set((AbstractInsnNode)mn, (AbstractInsnNode)new InsnNode(3));
                return true;
            }
        } else {
            Transformer.log().error("Unable to locate method {}{}", (Object)names[0], (Object)"()V");
        }
        Transformer.log().info("Unable to patch [{}]!", (Object)this.getClassName());
        return false;
    }
}

