/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.asm;

import org.blockartistry.DynSurround.asm.TransformLoader;
import org.blockartistry.DynSurround.asm.Transformer;
import org.blockartistry.DynSurround.asm.Transmorgrifier;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class PatchSoundManagerSync
extends Transmorgrifier {
    public PatchSoundManagerSync() {
        super("net.minecraft.client.audio.SoundManager");
    }

    @Override
    public String name() {
        return "SoundManager synchronization";
    }

    @Override
    public boolean isEnabled() {
        return TransformLoader.config.getBoolean("Enable synchronized for SoundManager", "asm", true, "");
    }

    @Override
    public boolean transmorgrify(ClassNode cn) {
        for (MethodNode m : cn.methods) {
            if (m.name.startsWith("<") || (m.access & 1) == 0 || (m.access & 0x20) != 0) continue;
            this.logMethod(Transformer.log(), m, "Synchronized!");
            m.access |= 0x20;
        }
        return true;
    }
}

