/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.client;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.BlueprintChunk;
import com.ldtteam.structures.lib.BlueprintUtils;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Biomes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import org.jetbrains.annotations.NotNull;

public class BlueprintBlockAccess
extends World
implements IBlockAccess {
    private final Blueprint blueprint;

    public BlueprintBlockAccess(Blueprint blueprint) {
        super(Minecraft.func_71410_x().field_71441_e.func_72860_G(), Minecraft.func_71410_x().field_71441_e.func_72912_H(), Minecraft.func_71410_x().field_71441_e.field_73011_w, Minecraft.func_71410_x().field_71441_e.field_72984_F, true);
        this.blueprint = blueprint;
    }

    public Blueprint getBlueprint() {
        return this.blueprint;
    }

    @Nullable
    public TileEntity func_175625_s(@NotNull BlockPos pos) {
        return BlueprintUtils.getTileEntityFromPos(this.blueprint, pos, this);
    }

    public int func_175626_b(@NotNull BlockPos pos, int lightValue) {
        return 0xF000F0;
    }

    public int func_175699_k(BlockPos pos) {
        return 15;
    }

    public float func_175724_o(@NotNull BlockPos pos) {
        return 1.0f;
    }

    @NotNull
    public IBlockState func_180495_p(@NotNull BlockPos pos) {
        return BlueprintUtils.getBlockInfoFromPos(this.blueprint, pos).getState();
    }

    public boolean func_175623_d(@NotNull BlockPos pos) {
        return this.func_180495_p(pos).func_177230_c() instanceof BlockAir;
    }

    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return true;
    }

    @NotNull
    public Biome func_180494_b(@NotNull BlockPos pos) {
        return Biomes.field_76772_c;
    }

    @NotNull
    public Chunk func_175726_f(BlockPos pos) {
        return this.func_72964_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    @NotNull
    public Chunk func_72964_e(int chunkX, int chunkZ) {
        return new BlueprintChunk(this, chunkX, chunkZ);
    }

    @NotNull
    protected IChunkProvider func_72970_h() {
        return Minecraft.func_71410_x().field_71441_e.func_72863_F();
    }

    public int func_175627_a(@NotNull BlockPos pos, @NotNull EnumFacing direction) {
        return 0;
    }

    @NotNull
    public WorldType func_175624_G() {
        return WorldType.field_77137_b;
    }

    public boolean isSideSolid(@NotNull BlockPos pos, @NotNull EnumFacing side, boolean def) {
        return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
    }
}

